/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef _mx_klib_test_h_
#define _mx_klib_test_h_

#include <sys/stddef.h>
#include <sys/types.h>
#include <sys/systm.h>
#include <sys/malloc.h>
#include <sys/param.h>
#include <sys/module.h>
#include <sys/sysent.h>
#include <sys/kernel.h>
#include <vm/vm.h>
#include <vm/pmap.h>
#include "mx_pin.h"

#define PRINT printf

static inline void *
alloc_buffer(size_t len, uint32_t pin_type)
{
  if  (pin_type == MX_PIN_PHYSICAL)
    return contigmalloc(len, M_DEVBUF, M_WAITOK, 0, -1L, 1, 1 << 31);
  else if (pin_type == MX_PIN_KERNEL)
    return malloc(len, M_DEVBUF, M_WAITOK);
  else
    return NULL;
}

static inline void
free_buffer(void *ptr, size_t len, uint32_t pin_type)
{
  if  (pin_type == MX_PIN_PHYSICAL)
    contigfree(ptr, len, M_DEVBUF);
  else if (pin_type == MX_PIN_KERNEL)
    free(ptr, M_DEVBUF);
}

#define virt_to_phys(x) pmap_kextract((vm_offset_t)x)

static inline int
compare(void *ptr1, void *ptr2, size_t len, uint32_t pin_type)
{
  if  (pin_type == MX_PIN_PHYSICAL
       || pin_type == MX_PIN_KERNEL)
    return memcmp(ptr1, ptr2, pin_type);
  else
    return -1;
}

static inline void
fill_pattern(char *dst, char *src, size_t len, uint32_t pin_type) {
  int i,j = 128;
  for(i=0; i<len; i+=j) {
    if (j > len-i)
      j = len-i;
  if  (pin_type == MX_PIN_PHYSICAL
       || pin_type == MX_PIN_KERNEL)
    bcopy(src, dst+i, j);
  }
}

#define DO_MODULE(init_func, cleanup_func)				\
static int								\
load(struct module *module, int cmd, void *arg)				\
{									\
  int error = 0;							\
  switch (cmd) {							\
  case MOD_LOAD :							\
    init_func();							\
    break;								\
  case MOD_UNLOAD :							\
    cleanup_func();							\
    break;								\
  default :								\
    error = EINVAL;							\
    break;								\
  }									\
  return error;								\
}									\
									\
static moduledata_t mod_data= {						\
	"mx_klib_test",							\
        load,								\
        0								\
};									\
									\
DECLARE_MODULE(mx_klib_test, mod_data, SI_SUB_EXEC, SI_ORDER_ANY);	\
MODULE_DEPEND(mx_klib_test, mx, 1, 1, 1);				\


#endif /* _mx_klib_test_h_ */
